define([
    'App',
    'modules/notification-preferences/notification-preferences-model',
], function(app, NotificationPreferences) {
    'use strict';

    return {
        notificationPreferences: new (NotificationPreferences.extend({
            _isReady: new $.Deferred(),
            initialize: function() {
                this.once('sync', function() {
                    this._isReady.resolve();
                }, this);
            },

            getUrl: function(user) {
                return app.resources.get('notification-preference').formatHref({
                    'assigning-authority': user.get('idType'),
                    'patient-id': user.id,
                });
            },

            savePreferences: function(data, user) {
                var url = this.getUrl(user);
                return this.save(data, {
                    url: url,
                    type: 'PUT',
                });
            },
        }))(),
    };
});
